<?php
// +----------------------------------------------------------------------
// | 海豚PHP框架 [ DolphinPHP ]
// +----------------------------------------------------------------------
// | 版权所有 2016~2017 河源市卓锐科技有限公司 [ http://www.zrthink.com ]
// +----------------------------------------------------------------------
// | 官方网站: http://dolphinphp.com
// +----------------------------------------------------------------------
// | 开源协议 ( http://www.apache.org/licenses/LICENSE-2.0 )
// +----------------------------------------------------------------------

namespace app\update\admin;

use app\common\controller\Common;
use think\Db;
use util\File;

/**
 * 仪表盘控制器
 * @package app\cms\admin
 */
class Index extends Common
{
    protected function _initialize()
    {
        parent::_initialize();
        if (config('dolphin.product_version') == '1.2.0') {
            die('<h1 style="text-align: center;color:red">当前版本已经是V1.2.0，无需升级！</h1>');
        }
        if (config('dolphin.product_version') != '1.1.0') {
            $this->error('<h1 style="text-align: center;color:red">框架版本不符合，无法升级</h1>');
        }
    }

    /**
     * 首页
     * @return mixed
     */
    public function index()
    {
        return $this->fetch();
    }

    /**
     * 更新数据库
     */
    public function updatedata()
    {
        $menu_user = Db::name('admin_menu')->where(['pid' => 0, 'module' => 'user'])->find();
        !$menu_user && $this->error('数据库更新失败，找不到用户模块菜单');

        /**
         * ==============
         * 添加消息管理菜单（开始）
         * ==============
         */
        $data = [
            'pid'         => $menu_user['id'],
            'module'      => 'user',
            'title'       => '消息管理',
            'icon'        => 'fa fa-fw fa-comments-o',
            'url_type'    => 'module_admin',
            'url_value'   => '',
            'url_target'  => '_self',
            'online_hide' => 0,
            'sort'        => 100
        ];
        $id = Db::name('admin_menu')->insertGetId($data);

        $data = [
            'pid'         => $id,
            'module'      => 'user',
            'title'       => '消息列表',
            'icon'        => 'fa fa-fw fa-th-list',
            'url_type'    => 'module_admin',
            'url_value'   => 'user/message/index',
            'url_target'  => '_self',
            'online_hide' => 0,
            'sort'        => 100,
        ];
        $id = Db::name('admin_menu')->insertGetId($data);

        $data = [
            [
                'pid'         => $id,
                'module'      => 'user',
                'title'       => '新增',
                'icon'        => '',
                'url_type'    => 'module_admin',
                'url_value'   => 'user/message/add',
                'url_target'  => '_self',
                'online_hide' => 0,
                'sort'        => 100,
            ],
            [
                'pid'         => $id,
                'module'      => 'user',
                'title'       => '编辑',
                'icon'        => '',
                'url_type'    => 'module_admin',
                'url_value'   => 'user/message/edit',
                'url_target'  => '_self',
                'online_hide' => 0,
                'sort'        => 100,
            ],
            [
                'pid'         => $id,
                'module'      => 'user',
                'title'       => '删除',
                'icon'        => '',
                'url_type'    => 'module_admin',
                'url_value'   => 'user/message/delete',
                'url_target'  => '_self',
                'online_hide' => 0,
                'sort'        => 100,
            ],
            [
                'pid'         => $id,
                'module'      => 'user',
                'title'       => '启用',
                'icon'        => '',
                'url_type'    => 'module_admin',
                'url_value'   => 'user/message/enable',
                'url_target'  => '_self',
                'online_hide' => 0,
                'sort'        => 100,
            ],
            [
                'pid'         => $id,
                'module'      => 'user',
                'title'       => '禁用',
                'icon'        => '',
                'url_type'    => 'module_admin',
                'url_value'   => 'user/message/disable',
                'url_target'  => '_self',
                'online_hide' => 0,
                'sort'        => 100,
            ],
            [
                'pid'         => $id,
                'module'      => 'user',
                'title'       => '快速编辑',
                'icon'        => '',
                'url_type'    => 'module_admin',
                'url_value'   => 'user/message/quickedit',
                'url_target'  => '_self',
                'online_hide' => 0,
                'sort'        => 100,
            ]
        ];

        Db::name('admin_menu')->insertAll($data);

        $data = [
            'pid'         => '2',
            'module'      => 'admin',
            'title'       => '消息中心',
            'icon'        => 'fa fa-fw fa-comments-o',
            'url_type'    => 'module_admin',
            'url_value'   => 'admin/message/index',
            'url_target'  => '_self',
            'online_hide' => 0,
            'sort'        => 100
        ];
        $id = Db::name('admin_menu')->insertGetId($data);

        $data = [
            [
                'pid'         => $id,
                'module'      => 'admin',
                'title'       => '删除',
                'icon'        => '',
                'url_type'    => 'module_admin',
                'url_value'   => 'admin/message/delete',
                'url_target'  => '_self',
                'online_hide' => 0,
                'sort'        => 100,
            ],
            [
                'pid'         => $id,
                'module'      => 'admin',
                'title'       => '启用',
                'icon'        => '',
                'url_type'    => 'module_admin',
                'url_value'   => 'admin/message/enable',
                'url_target'  => '_self',
                'online_hide' => 0,
                'sort'        => 100,
            ]
        ];
        Db::name('admin_menu')->insertAll($data);
        /**
         * ==============
         * 添加消息管理菜单（结束）
         * ==============
         */

        /**
         * ==============
         * 添加图标管理菜单（开始）
         * ==============
         */
        $data = [
            'pid'         => '32',
            'module'      => 'admin',
            'title'       => '图标管理',
            'icon'        => 'fa fa-fw fa-tint',
            'url_type'    => 'module_admin',
            'url_value'   => 'admin/icon/index',
            'url_target'  => '_self',
            'online_hide' => 0,
            'sort'        => 100
        ];
        $id = Db::name('admin_menu')->insertGetId($data);

        $data = [
            [
                'pid'         => $id,
                'module'      => 'admin',
                'title'       => '新增',
                'icon'        => '',
                'url_type'    => 'module_admin',
                'url_value'   => 'admin/icon/add',
                'url_target'  => '_self',
                'online_hide' => 0,
                'sort'        => 100,
            ],
            [
                'pid'         => $id,
                'module'      => 'admin',
                'title'       => '编辑',
                'icon'        => '',
                'url_type'    => 'module_admin',
                'url_value'   => 'admin/icon/edit',
                'url_target'  => '_self',
                'online_hide' => 0,
                'sort'        => 100,
            ],
            [
                'pid'         => $id,
                'module'      => 'admin',
                'title'       => '删除',
                'icon'        => '',
                'url_type'    => 'module_admin',
                'url_value'   => 'admin/icon/delete',
                'url_target'  => '_self',
                'online_hide' => 0,
                'sort'        => 100,
            ],
            [
                'pid'         => $id,
                'module'      => 'admin',
                'title'       => '启用',
                'icon'        => '',
                'url_type'    => 'module_admin',
                'url_value'   => 'admin/icon/enable',
                'url_target'  => '_self',
                'online_hide' => 0,
                'sort'        => 100,
            ],
            [
                'pid'         => $id,
                'module'      => 'admin',
                'title'       => '禁用',
                'icon'        => '',
                'url_type'    => 'module_admin',
                'url_value'   => 'admin/icon/disable',
                'url_target'  => '_self',
                'online_hide' => 0,
                'sort'        => 100,
            ],
            [
                'pid'         => $id,
                'module'      => 'admin',
                'title'       => '快速编辑',
                'icon'        => '',
                'url_type'    => 'module_admin',
                'url_value'   => 'admin/icon/quickedit',
                'url_target'  => '_self',
                'online_hide' => 0,
                'sort'        => 100,
            ],
            [
                'pid'         => $id,
                'module'      => 'admin',
                'title'       => '图标列表',
                'icon'        => '',
                'url_type'    => 'module_admin',
                'url_value'   => 'admin/icon/items',
                'url_target'  => '_self',
                'online_hide' => 0,
                'sort'        => 100,
            ],
            [
                'pid'         => $id,
                'module'      => 'admin',
                'title'       => '更新图标',
                'icon'        => '',
                'url_type'    => 'module_admin',
                'url_value'   => 'admin/icon/reload',
                'url_target'  => '_self',
                'online_hide' => 0,
                'sort'        => 100,
            ],
        ];
        Db::name('admin_menu')->insertAll($data);
        /**
         * ==============
         * 添加图标管理菜单（结束）
         * ==============
         */

        /**
         * ==============
         * 添加消息管理相关表（开始）
         * ==============
         */
        $table_name = config('database.prefix').'admin_message';

        $sql = <<<EOF
                CREATE TABLE `{$table_name}` (
                  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
                  `uid_receive` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '接收消息的用户id',
                  `uid_send` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '发送消息的用户id',
                  `type` varchar(128) NOT NULL DEFAULT '' COMMENT '消息分类',
                  `content` text NOT NULL COMMENT '消息内容',
                  `status` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '状态',
                  `create_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
                  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
                  `read_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '阅读时间',
                  PRIMARY KEY (`id`)
                ) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='消息表';
EOF;
        try {
            Db::execute($sql);
        } catch(\Exception $e) {
            $this->error('表：'.$table_name.' 创建失败');
        }
        /**
         * ==============
         * 添加消息管理相关表（结束）
         * ==============
         */

        /**
         * ==============
         * 添加图标管理相关表（开始）
         * ==============
         */
        $table_name = config('database.prefix').'admin_icon';

        $sql = <<<EOF
                CREATE TABLE `{$table_name}` (
                  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
                  `name` varchar(32) NOT NULL DEFAULT '' COMMENT '图标名称',
                  `url` varchar(255) NOT NULL DEFAULT '' COMMENT '图标css地址',
                  `prefix` varchar(32) NOT NULL DEFAULT '' COMMENT '图标前缀',
                  `font_family` varchar(32) NOT NULL DEFAULT '' COMMENT '字体名',
                  `create_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '创建时间',
                  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
                  `status` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '状态',
                  PRIMARY KEY (`id`)
                ) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='图标表';
EOF;
        try {
            Db::execute($sql);
        } catch(\Exception $e) {
            $this->error('表：'.$table_name.' 创建失败');
        }

        $table_name = config('database.prefix').'admin_icon_list';

        $sql = <<<EOF
                CREATE TABLE `{$table_name}` (
                  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
                  `icon_id` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '所属图标id',
                  `title` varchar(128) NOT NULL DEFAULT '' COMMENT '图标标题',
                  `class` varchar(255) NOT NULL DEFAULT '' COMMENT '图标类名',
                  `code` varchar(128) NOT NULL DEFAULT '' COMMENT '图标关键词',
                  PRIMARY KEY (`id`)
                ) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='详细图标列表';
EOF;
        try {
            Db::execute($sql);
        } catch(\Exception $e) {
            $this->error('表：'.$table_name.' 创建失败');
        }
        /**
         * ==============
         * 添加图标管理相关表（结束）
         * ==============
         */

        /**
         * ==============
         * 更新角色表（开始）
         * ==============
         */
        $table_name = config('database.prefix').'admin_role';

        $sql = <<<EOF
                ALTER TABLE `{$table_name}`
                ADD COLUMN `default_module` int(11) UNSIGNED NOT NULL DEFAULT 0 COMMENT '默认访问模块' AFTER `access`;
EOF;
        try {
            Db::execute($sql);
        } catch(\Exception $e) {
            $this->error('表：'.$table_name.' 更新失败');
        }
        /**
         * ==============
         * 更新角色表（结束）
         * ==============
         */

        /**
         * ==============
         * 更新附件表（开始）
         * ==============
         */
        $table_name = config('database.prefix').'admin_attachment';

        $sql = <<<EOF
                ALTER TABLE `{$table_name}`
                ADD COLUMN `width`  int(8) UNSIGNED NOT NULL DEFAULT 0 COMMENT '图片宽度' AFTER `status`,
                ADD COLUMN `height`  int(8) UNSIGNED NOT NULL DEFAULT 0 COMMENT '图片高度' AFTER `width`;
EOF;
        try {
            Db::execute($sql);
        } catch(\Exception $e) {
            $this->error('表：'.$table_name.' 更新失败');
        }
        /**
         * ==============
         * 更新附件表（结束）
         * ==============
         */

        $this->success('更新成功');
    }

    /**
     * 更新文件
     */
    public function updateFile()
    {
        // 复制静态资源目录
        if (false == File::copy_dir(APP_PATH. 'update/files/application', ROOT_PATH.'application')) {
            $this->error('application目录更新失败');
        }
        if (false == File::copy_dir(APP_PATH. 'update/files/public', ROOT_PATH.'public')) {
            $this->error('public目录更新失败');
        }
        if (false == File::copy_dir(APP_PATH. 'update/files/thinkphp', ROOT_PATH.'thinkphp')) {
            $this->error('thinkphp目录更新失败');
        }
        if (false == File::copy_dir(APP_PATH. 'update/files/vendor', ROOT_PATH.'vendor')) {
            $this->error('vendor目录更新失败');
        }
        if (false == copy(APP_PATH. 'update/files/composer.json', ROOT_PATH.'composer.json')) {
            $this->error('composer.json文件更新失败');
        }
        if (false == copy(APP_PATH. 'update/files/composer.lock', ROOT_PATH.'composer.lock')) {
            $this->error('composer.lock文件更新失败');
        }
        $this->wipeCache();
        $this->success('更新成功');
    }

    /**
     * 清除缓存
     */
    private function wipeCache()
    {
        if (!empty(config('wipe_cache_type'))) {
            foreach (config('wipe_cache_type') as $item) {
                if ($item == 'LOG_PATH') {
                    $dirs = (array) glob(constant($item) . '*');
                    foreach ($dirs as $dir) {
                        array_map('unlink', glob($dir . '/*.log'));
                    }
                    array_map('rmdir', $dirs);
                } else {
                    array_map('unlink', glob(constant($item) . '/*.*'));
                }
            }
            \think\Cache::clear();
        }
    }
}